//+------------------------------------------------------------------+
//|                                              Stochastic Bars.mq4 |
//|                 Copyright 2010 Toshiyuki Tega (Softgate Limited) |
//|                                       http://www.softgate.co.jp/ |
//+------------------------------------------------------------------+
#property copyright "Copyright 2010 Toshiyuki Tega (Softgate Limited)"
#property link      "http://www.softgate.co.jp/"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Pink
#property indicator_color2 Pink
#property indicator_color3 Lime
#property indicator_color4 Lime

extern int KPeriod = 8;
extern int DPeriod = 3;
extern int Slowing = 3;
extern int Type = 0;
extern int OverBought = 80;
extern int OverSold = 20;
extern int Timeframe = 0;
extern int BarWidth = 3;

double buffer0[], buffer1[], buffer2[], buffer3[];

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
  SetIndexStyle(0, DRAW_HISTOGRAM, 0, BarWidth);
  SetIndexBuffer(0, buffer0);
  SetIndexLabel(0, NULL);
  SetIndexStyle(1, DRAW_HISTOGRAM, 0, BarWidth);
  SetIndexBuffer(1, buffer1);
  SetIndexLabel(1, NULL);
  SetIndexStyle(2, DRAW_HISTOGRAM, 0, BarWidth);
  SetIndexBuffer(2, buffer2);
  SetIndexLabel(2, NULL);
  SetIndexStyle(3, DRAW_HISTOGRAM, 0, BarWidth);
  SetIndexBuffer(3, buffer3);
  SetIndexLabel(3, NULL);

  IndicatorShortName("Stochastic Bars (" + KPeriod + "," + DPeriod + "," + Slowing + "," + Type + "," + OverBought + "," + OverSold + ")");
  
  return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{
  return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
  int countedBars = IndicatorCounted();
  int barsNeeded = Bars - countedBars;
  
  for (int i = 0; i < barsNeeded; i++)
  {
    int shift = iBarShift(NULL, Timeframe, iTime(NULL, 0, i));
    double stoch = iStochastic(NULL, Timeframe, KPeriod, DPeriod, Slowing, MODE_SMA, Type, MODE_MAIN, shift);
    
    buffer0[i] = 0; buffer1[i] = 0; buffer2[i] = 0; buffer3[i] = 0;
    
    if (stoch >= OverBought)
    {
      buffer0[i] = High[i] + Point;
      buffer1[i] = Low[i] - Point;
    }
    else if (stoch <= OverSold)
    {
      buffer2[i] = High[i] + Point;
      buffer3[i] = Low[i] - Point;
    }
  }
  
  return(0);
}

